<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["expenditure_code.department_code"] )) {
			$lookupTableLinks["department"]["expenditure_code.department_code"] = array();
		}
		$lookupTableLinks["department"]["expenditure_code.department_code"]["edit"] = array("table" => "expenditure_code", "field" => "department_code", "page" => "edit");
		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["expenditure_code.department_name"] )) {
			$lookupTableLinks["department"]["expenditure_code.department_name"] = array();
		}
		$lookupTableLinks["department"]["expenditure_code.department_name"]["edit"] = array("table" => "expenditure_code", "field" => "department_name", "page" => "edit");
		if( !isset( $lookupTableLinks["description"] ) ) {
			$lookupTableLinks["description"] = array();
		}
		if( !isset( $lookupTableLinks["description"]["expenditure_code.description"] )) {
			$lookupTableLinks["description"]["expenditure_code.description"] = array();
		}
		$lookupTableLinks["description"]["expenditure_code.description"]["edit"] = array("table" => "expenditure_code", "field" => "description", "page" => "edit");
		if( !isset( $lookupTableLinks["main ledger"] ) ) {
			$lookupTableLinks["main ledger"] = array();
		}
		if( !isset( $lookupTableLinks["main ledger"]["allocation.expenditure_code"] )) {
			$lookupTableLinks["main ledger"]["allocation.expenditure_code"] = array();
		}
		$lookupTableLinks["main ledger"]["allocation.expenditure_code"]["add"] = array("table" => "allocation", "field" => "expenditure_code", "page" => "add");
		if( !isset( $lookupTableLinks["main ledger"] ) ) {
			$lookupTableLinks["main ledger"] = array();
		}
		if( !isset( $lookupTableLinks["main ledger"]["allocation.expenditure_code"] )) {
			$lookupTableLinks["main ledger"]["allocation.expenditure_code"] = array();
		}
		$lookupTableLinks["main ledger"]["allocation.expenditure_code"]["search"] = array("table" => "allocation", "field" => "expenditure_code", "page" => "search");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["allocation_detail.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["allocation_detail.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["allocation_detail.sub_office_code"]["edit"] = array("table" => "allocation_detail", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["allocation_users.sub_office"] )) {
			$lookupTableLinks["sub_office"]["allocation_users.sub_office"] = array();
		}
		$lookupTableLinks["sub_office"]["allocation_users.sub_office"]["edit"] = array("table" => "allocation_users", "field" => "sub_office", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["allocation_users.address"] )) {
			$lookupTableLinks["sub_office"]["allocation_users.address"] = array();
		}
		$lookupTableLinks["sub_office"]["allocation_users.address"]["edit"] = array("table" => "allocation_users", "field" => "address", "page" => "edit");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["allocation_from_departments.expenditure_code"] )) {
			$lookupTableLinks["expenditure_code"]["allocation_from_departments.expenditure_code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["allocation_from_departments.expenditure_code"]["edit"] = array("table" => "allocation_from_departments", "field" => "expenditure_code", "page" => "edit");
		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["expenditure_code_view_for_sub_office.department_code"] )) {
			$lookupTableLinks["department"]["expenditure_code_view_for_sub_office.department_code"] = array();
		}
		$lookupTableLinks["department"]["expenditure_code_view_for_sub_office.department_code"]["edit"] = array("table" => "expenditure_code_view_for_sub_office", "field" => "department_code", "page" => "edit");
		if( !isset( $lookupTableLinks["description"] ) ) {
			$lookupTableLinks["description"] = array();
		}
		if( !isset( $lookupTableLinks["description"]["expenditure_code_view_for_sub_office.description"] )) {
			$lookupTableLinks["description"]["expenditure_code_view_for_sub_office.description"] = array();
		}
		$lookupTableLinks["description"]["expenditure_code_view_for_sub_office.description"]["edit"] = array("table" => "expenditure_code_view_for_sub_office", "field" => "description", "page" => "edit");
		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["main_ledger.department_code"] )) {
			$lookupTableLinks["department"]["main_ledger.department_code"] = array();
		}
		$lookupTableLinks["department"]["main_ledger.department_code"]["edit"] = array("table" => "main ledger", "field" => "department_code", "page" => "edit");
		if( !isset( $lookupTableLinks["description"] ) ) {
			$lookupTableLinks["description"] = array();
		}
		if( !isset( $lookupTableLinks["description"]["main_ledger.description"] )) {
			$lookupTableLinks["description"]["main_ledger.description"] = array();
		}
		$lookupTableLinks["description"]["main_ledger.description"]["edit"] = array("table" => "main ledger", "field" => "description", "page" => "edit");
		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["main_ledger.department_name"] )) {
			$lookupTableLinks["department"]["main_ledger.department_name"] = array();
		}
		$lookupTableLinks["department"]["main_ledger.department_name"]["edit"] = array("table" => "main ledger", "field" => "department_name", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["list.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["list.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["list.sub_office_code"]["edit"] = array("table" => "list", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["detail.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["detail.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["detail.sub_office_code"]["edit"] = array("table" => "detail", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["issued_list.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["issued_list.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["issued_list.sub_office_code"]["edit"] = array("table" => "issued list", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["allocation_list.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["allocation_list.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["allocation_list.sub_office_code"]["edit"] = array("table" => "allocation_list", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["details.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["details.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["details.sub_office_code"]["search"] = array("table" => "Details", "field" => "sub_office_code", "page" => "search");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["advanced_allocation_letter.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["advanced_allocation_letter.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["advanced_allocation_letter.sub_office_code"]["search"] = array("table" => "Advanced_allocation_letter", "field" => "sub_office_code", "page" => "search");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["allocation_request.expenditure_code"] )) {
			$lookupTableLinks["expenditure_code"]["allocation_request.expenditure_code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["allocation_request.expenditure_code"]["edit"] = array("table" => "allocation_request", "field" => "expenditure_code", "page" => "edit");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["expenditure_statement.code"] )) {
			$lookupTableLinks["expenditure_code"]["expenditure_statement.code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["expenditure_statement.code"]["add"] = array("table" => "expenditure_statement", "field" => "code", "page" => "add");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["expenditure_statement.code"] )) {
			$lookupTableLinks["expenditure_code"]["expenditure_statement.code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["expenditure_statement.code"]["search"] = array("table" => "expenditure_statement", "field" => "code", "page" => "search");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["allocation_detail_report.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["allocation_detail_report.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["allocation_detail_report.sub_office_code"]["search"] = array("table" => "allocation_detail Report", "field" => "sub_office_code", "page" => "search");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["report_builder.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["report_builder.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["report_builder.sub_office_code"]["edit"] = array("table" => "Report builder", "field" => "sub_office_code", "page" => "edit");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["report_builder.expenditure_code"] )) {
			$lookupTableLinks["expenditure_code"]["report_builder.expenditure_code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["report_builder.expenditure_code"]["edit"] = array("table" => "Report builder", "field" => "expenditure_code", "page" => "edit");
		if( !isset( $lookupTableLinks["department"] ) ) {
			$lookupTableLinks["department"] = array();
		}
		if( !isset( $lookupTableLinks["department"]["report_builder.department"] )) {
			$lookupTableLinks["department"]["report_builder.department"] = array();
		}
		$lookupTableLinks["department"]["report_builder.department"]["edit"] = array("table" => "Report builder", "field" => "department", "page" => "edit");
		if( !isset( $lookupTableLinks["allocation_detail"] ) ) {
			$lookupTableLinks["allocation_detail"] = array();
		}
		if( !isset( $lookupTableLinks["allocation_detail"]["report_builder.comment"] )) {
			$lookupTableLinks["allocation_detail"]["report_builder.comment"] = array();
		}
		$lookupTableLinks["allocation_detail"]["report_builder.comment"]["add"] = array("table" => "Report builder", "field" => "comment", "page" => "add");
		if( !isset( $lookupTableLinks["allocation_detail"] ) ) {
			$lookupTableLinks["allocation_detail"] = array();
		}
		if( !isset( $lookupTableLinks["allocation_detail"]["report_builder.description"] )) {
			$lookupTableLinks["allocation_detail"]["report_builder.description"] = array();
		}
		$lookupTableLinks["allocation_detail"]["report_builder.description"]["edit"] = array("table" => "Report builder", "field" => "description", "page" => "edit");
		if( !isset( $lookupTableLinks["expenditure_code"] ) ) {
			$lookupTableLinks["expenditure_code"] = array();
		}
		if( !isset( $lookupTableLinks["expenditure_code"]["allocation_request_admin_page.expenditure_code"] )) {
			$lookupTableLinks["expenditure_code"]["allocation_request_admin_page.expenditure_code"] = array();
		}
		$lookupTableLinks["expenditure_code"]["allocation_request_admin_page.expenditure_code"]["edit"] = array("table" => "allocation_request admin page", "field" => "expenditure_code", "page" => "edit");
		if( !isset( $lookupTableLinks["sub_office"] ) ) {
			$lookupTableLinks["sub_office"] = array();
		}
		if( !isset( $lookupTableLinks["sub_office"]["report2.sub_office_code"] )) {
			$lookupTableLinks["sub_office"]["report2.sub_office_code"] = array();
		}
		$lookupTableLinks["sub_office"]["report2.sub_office_code"]["edit"] = array("table" => "Report2", "field" => "sub_office_code", "page" => "edit");
}

?>